#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include <WiFiManager.h>
#include <WiFiClient.h> 
#include <OneWire.h>
#include <PietteTech_DHT.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266httpUpdate.h>

// Modifica cu datele tale
const char* mqttUser = "qbzesh";
const char* mqttPassword = "8219CHqbzesh";
const char* mqttSUB = "cmnd/qbzesh-1250/ESP";
const char* mqttESP = "stat/qbzesh-1250/ESP";
const char* mqttTEMP = "stat/qbzesh-1250/TEMP";
const char* mqttLWT = "tele/qbzesh-1250/LWT";
const char* espName ="qbzesh-1250";

//#######################################################################
// NU EDITA MAI JOS
//#######################################################################
const String model = "NodeMCU DHT22";
const String ver = "v1.0.6";
const char* mqttServer = "mqtt.clickhome.ro";
const int mqttPort = 1883;
long loopTimer = 900000; // miliseconds - by default trimite la 15 minute
long lastMsg = 0;
float loopTemp = 0;
float t = 0;
float loopHumi = 0;
float h = 0;
String mqttMessage;
bool bDHTstarted;
int acquireresult;

// senzor de temperatura DHT
#define DHTPIN D4 // pinul de date (la mine am pus senzor pe D4)
#define DHTTYPE DHT22 // DHT 11
void dht_wrapper();
PietteTech_DHT DHT(DHTPIN, DHTTYPE, dht_wrapper);
void dht_wrapper() 
{
  DHT.isrCallback();
}
//*********************************************************************

WiFiClient espClient;
PubSubClient client(espClient);


String ipToString(IPAddress ip){
  String s="";
  for (int i=0; i<4; i++)
    s += i  ? "." + String(ip[i]) : String(ip[i]);
  return s;
}

String getMacAddress() {
  byte mac[6];
  WiFi.macAddress(mac);
  String cMac = "";
  for (int i = 0; i < 6; ++i) {
    cMac += String(mac[i],HEX);
    if(i<5)
    cMac += "-";
  }
  cMac.toUpperCase();
  return cMac;
}

void reconnect() 
{
  while (!client.connected()) 
  {
    //Serial.println("Reconectare la MQTT ...");
    // Incerc sa ma reconectez cu LWT din 60 in 60 secunde
    if (client.connect(espName, mqttUser, mqttPassword, mqttLWT, 1, 1, "Offline")) 
    {
      Serial.println("Senzor reconectat la MQTT.");
      client.publish(mqttLWT,"Online",TRUE);
      // trimit informatii utile cand ma conectez
        String esp_info = "{\"ESPMac\":\"";
        esp_info += getMacAddress();
        esp_info += "\", \"IPAddress\":\"";
        esp_info += ipToString(WiFi.localIP());    
        esp_info += "\"}";       
        String netinfo = "{\"Module\":\"";
        netinfo += String (model);
        netinfo += "\", \"Version\":\"";
        netinfo += String (ver);
        netinfo += "\"}";            
        
        client.publish(mqttESP, netinfo.c_str(),TRUE);
        Serial.println(netinfo);
        client.publish(mqttESP, esp_info.c_str(),TRUE);
        Serial.println(esp_info);
        client.publish(mqttESP, "15 minute",TRUE); // trimit intervalul default
        client.subscribe(mqttSUB);
    } 
    else 
    {
        Serial.println("Reconectare MQTT esuata: ");
        Serial.println(client.state());
        Serial.println("fac o alta incercare in 60 de secunde");
        delay(60000);
    }
  }
}
 
void setup()
{
  Serial.begin(115200);

  // ma conectez la AP via wifi
   WiFiManager wifi;
   wifi.setTimeout(180); // sta AP 3 minute apoi se reseteaza din nou
   if (!wifi.autoConnect("ClickHome")) {
     Serial.println("timeout - going to sleep");
  }
  delay(200);
 
  // ma conectez la mqtt server
  client.setServer(mqttServer, mqttPort);
    while (!client.connected()) {
    Serial.println("Conectare la MQTT ...");
    // fac connect cu LWT
    if (client.connect(espName, mqttUser, mqttPassword, mqttLWT, 1, 1, "Offline")) {
      Serial.println("Senzor conectat la MQTT.");
      // trimit starea Online pe topic LWT cand ma conectez
      client.publish(mqttLWT,"Online",TRUE);
      // trimit informatii utile cand ma conectez
        String esp_info = "{\"ESPMac\":\"";
        esp_info += getMacAddress();
        esp_info += "\", \"IPAddress\":\"";
        esp_info += ipToString(WiFi.localIP());    
        esp_info += "\"}";       
        String netinfo = "{\"Module\":\"";
        netinfo += String (model);
        netinfo += "\", \"Version\":\"";
        netinfo += String (ver);
        netinfo += "\"}";        
        client.publish(mqttESP, netinfo.c_str(),TRUE);
        Serial.println(netinfo);
        client.publish(mqttESP, esp_info.c_str(),TRUE);
        Serial.println(esp_info);
        client.publish(mqttESP, "{\"LoopInterval\":\"15 minute\"}",TRUE);   
        client.subscribe(mqttSUB);
      } 
      else {
        Serial.print("Conectare MQTT esuata: ");
        Serial.print(client.state());
        delay(2000);
    }
  }
  client.setCallback(getMessage);
}

void getMessage(char* topic, byte* payload, unsigned int length) {
  mqttMessage="";
  Serial.print("Message arrived in topic: ");
  Serial.println(topic);
  Serial.print("Message:");
  for (int i = 0; i < length; i++) {
    mqttMessage += (char)payload[i];
  }
  Serial.println(mqttMessage);
 
  // daca a primit temp va trimite temperatura 
  if (mqttMessage == "temp")
  {
      Serial.println("Trimit temperatura si umiditatea");
      acquireresult = DHT.acquireAndWait(2000);
      if ( acquireresult == 0 ) 
      {
           t = DHT.getCelsius();
           h = DHT.getHumidity();
           delay(10);
           String json = "{\"Temp\":";
           json += String (t);
           json += ", \"Humi\":";
           json += String (h);
           json += "}";  
           client.publish(mqttTEMP, json.c_str(),TRUE);
           Serial.println(json);
      } 
      else 
      {
        t = h = 0;
        Serial.println("Nu am putut citi temperatura si umiditatea");
      }    
  }  

  // procedura de software update via WEB
   if (mqttMessage == "update")
   {
        String msg="Software update: ";
        t_httpUpdate_return ret; 
        //ESPhttpUpdate.rebootOnUpdate(false);
        ret = ESPhttpUpdate.update("http://update.clickhome.ro/senzor/dht/arduino.bin");  
        //ret = ESPhttpUpdate.update("update.clickhome.ro", 80, "/senzor/dht/arduino.bin");
        switch(ret) {
           case HTTP_UPDATE_FAILED:
               msg.concat(" eroare:");
               msg.concat(ESPhttpUpdate.getLastError());
               msg.concat(" motiv:");
               msg.concat(ESPhttpUpdate.getLastErrorString().c_str());
               break;
           case HTTP_UPDATE_NO_UPDATES:
               msg.concat(" no update.");
               break;
           case HTTP_UPDATE_OK:
               msg.concat(" success.");
               break;
        }
        Serial.println(msg);
   }

  // daca a primit valoarea in minute seteaza loopTimer si-l trimite in DB
   if (mqttMessage == "debug")
   {
        loopTimer=30000; // setez sa trimita valori la 30 de secunde ca sa fac debug
        client.publish(mqttESP, "{\"LoopInterval\":\"30 secunde\"}",TRUE);   
   }
   if (mqttMessage == "10")
   {
        loopTimer=600000; // setez sa trimita valori la 10 minute   
        client.publish(mqttESP, "{\"LoopInterval\":\"10 minute\"}",TRUE);
   }
   if (mqttMessage == "15")
   {
        loopTimer=900000; // setez sa trimita valori la 15 minute
        client.publish(mqttESP, "{\"LoopInterval\":\"15 minute\"}",TRUE);   
   }
   if (mqttMessage == "30")
   {
        loopTimer=1800000; // setez sa trimita valori la 30 de minute
        client.publish(mqttESP, "{\"LoopInterval\":\"30 de minute\"}",TRUE);   
   }   
   if (mqttMessage == "60")
   {
        loopTimer=3600000; // setez sa trimita valori la o ora
        client.publish(mqttESP, "{\"LoopInterval\":\"o ora\"}",TRUE);   
   }
   if (mqttMessage == "stop")
   {
        loopTimer=3600000000; // setez sa nu trimita valori
        client.publish(mqttESP, "{\"LoopInterval\":\"oprit\"}",TRUE);
   }  
}

void loop()
{
  if (!client.connected()) {
    reconnect();
  }
  client.loop();
  long now = millis();
  if (now - lastMsg > loopTimer) {
     lastMsg = now;
     acquireresult = DHT.acquireAndWait(2000);
     if ( acquireresult == 0 ) 
      {
           loopTemp = DHT.getCelsius();
           loopHumi = DHT.getHumidity();
           delay(10);
           String val = "{\"Temp\":";
           val += String (loopTemp);
           val += ", \"Humi\":";
           val += String (loopHumi);
           val += "}";  
           client.publish(mqttESP, val.c_str(),TRUE);
      } 
      else 
      {
        loopTemp = loopHumi = 0;
      }
   }
}   
