#include <FS.h>                   //this needs to be first, or it all crashes and burns...
#include <ESP8266WiFi.h>          //https://github.com/esp8266/Arduino
#include <DNSServer.h>
#include <ESP8266WebServer.h>
#include <WiFiManager.h>          //https://github.com/tzapu/WiFiManager
#include <ArduinoJson.h>          //https://github.com/bblanchon/ArduinoJson pentru salvarea credentialelor in eprom



const char* comanda="save"; //valori posibile: save, erase
char* set_mqtt_user="exwrgq";
char* set_mqtt_devid="2638";



/*******************************
*       NU EDITA MAI JOS       *
*******************************/

char mqtt_user[9];
char mqtt_devid[5];

void setup() {
  Serial.begin(115200);

  //clean FS, for testing
  if (comanda == "erase"){
    SPIFFS.format();
    Serial.println("am formatat !");
    delay(1000000);
  }
  readFS();

  // The extra parameters to be configured (can be either global or just in the setup)
  // After connecting, parameter.getValue() will get you the configured value
  // id/name placeholder/prompt default length
  WiFiManagerParameter custom_mqtt_user("user", "mqtt user", mqtt_user, 9);
  WiFiManagerParameter custom_mqtt_devid("devid", "mqtt devid", mqtt_devid, 5);

  //WiFiManager
  //Local intialization. Once its business is done, there is no need to keep it around
  WiFiManager wifiManager;

  //set config save notify callback
  //wifiManager.setSaveConfigCallback(saveConfigCallback);

  //add all your parameters here
  //sters wifiManager.addParameter(&custom_mqtt_user); //apare campul in interfata web alaturi de SSID si pass de la WIfi 
  //sters wifiManager.addParameter(&custom_mqtt_devid);
  
  //reset settings - for testing
  //wifiManager.resetSettings();

  //set minimu quality of signal so it ignores AP's under that quality
  //defaults to 8%
  //wifiManager.setMinimumSignalQuality();
  
  //sets timeout until configuration portal gets turned off
  //useful to make it all retry or go to sleep
  //in seconds
  //wifiManager.setTimeout(120);

  //fetches ssid and pass and tries to connect
  //if it does not connect it starts an access point with the specified name
  //here  "AutoConnectAP"
  //and goes into a blocking loop awaiting configuration
  /*
  if (!wifiManager.autoConnect("ClickHOME")) {
    Serial.println("failed to connect and hit timeout");
    delay(3000);
    //reset and try again, or maybe put it to deep sleep
    ESP.reset();
    delay(5000);
  }
  */
  
  //read updated parameters
  strcpy(mqtt_user, custom_mqtt_user.getValue());
  strcpy(mqtt_devid, custom_mqtt_devid.getValue());

  Serial.print("setup read updated mqtt_user:");
  Serial.print(mqtt_user);
  Serial.println("read mqtt_devid:");
  Serial.println(mqtt_devid);

  if (comanda == "save"){
    strcpy(mqtt_user, set_mqtt_user);
    strcpy(mqtt_devid, set_mqtt_devid);
    saveFS();
  }
}

void saveFS(){
  //save the custom parameters to FS
  Serial.println("saving config");
  DynamicJsonBuffer jsonBuffer;
  JsonObject& json = jsonBuffer.createObject();
  json["mqtt_user"] = mqtt_user;
  json["mqtt_devid"] = mqtt_devid;

  File configFile = SPIFFS.open("/config.json", "w");
  if (!configFile) {
    Serial.println("failed to open config file for writing");
  }

  json.printTo(Serial);
  json.printTo(configFile);
  configFile.close();
  //end save
}

void readFS(){
  //read configuration from FS json
  Serial.println("mounting FS...");

  if (SPIFFS.begin()) {
    Serial.println("mounted file system");
    if (SPIFFS.exists("/config.json")) {
      //file exists, reading and loading
      Serial.println("reading config file");
      File configFile = SPIFFS.open("/config.json", "r");
      if (configFile) {
        Serial.println("opened config file");
        
        size_t size = configFile.size();
        // Allocate a buffer to store contents of the file.
        std::unique_ptr<char[]> buf(new char[size]);

        configFile.readBytes(buf.get(), size);
        DynamicJsonBuffer jsonBuffer;
        JsonObject& json = jsonBuffer.parseObject(buf.get());
        json.printTo(Serial);
        if (json.success()) {
          Serial.println("\nparsed json");

          strcpy(mqtt_user, json["mqtt_user"]);
          strcpy(mqtt_devid, json["mqtt_devid"]);

          Serial.print("read from FS updated mqtt_user:");
          Serial.println(mqtt_user);
          Serial.print("read mqtt_devid:");
          Serial.println(mqtt_devid);


        } else {
          Serial.println("failed to load json config");
        }
      }
    }
  } else {
    Serial.println("failed to mount FS");
  }
  //end read
}

void loop() {
  Serial.println("gata!");
  delay(100000);
}
