#include <FS.h>                   //this needs to be first, e folosit de salvarea credentialelor pe FS
#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include <WiFiManager.h>        //https://github.com/tzapu/WiFiManager
#include <ArduinoJson.h>          //https://github.com/bblanchon/ArduinoJson pentru salvarea credentialelor in eprom
#include <WiFiClient.h> 
#include <OneWire.h>
#include <DallasTemperature.h>
#include <ESP8266HTTPClient.h>
#include <ESP8266httpUpdate.h>

#define DEBUG 0 //0=off 1=on

const String model = "NodeMCU Dallas";
const String ver = "v2.2.0";
const char* mqttServer = "mqtt.clickhome.ro";
const int mqttPort = 1883;
long loopTimer = 900000; // miliseconds - by default trimite la 15 minute
long lastMsg = 0;
float loopTemp = 0;
String mqttMessage;
const unsigned long interval_update=1000*60*60; // face update la 60 min 
unsigned long t_update=0;

char mqtt_user[9]; //le va lua din FS
char mqtt_devid[5]; //le va lua din FS
char mqttPassword[15]; //urmatoarele le va genera cu functia gen
char mqttSUB[22];
char espName[13];
char mqttESP[22];
char mqttTEMP[23];
char mqttLWT[22];
char mqttSTA[24];

// senzor de temperatura DALLAS
#define ONE_WIRE_BUS D4  // pinul de date care se conecteaza la dallas
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

//*********************************************************************

WiFiClient espClient;
PubSubClient client(espClient);
bool readConfigFile();


void generate_vars(){
  strcpy (mqttPassword, "8219CH");
  strcat (mqttPassword, mqtt_user);

  strcpy (espName, mqtt_user);
  strcat (espName, "-");
  strcat (espName, mqtt_devid);

  strcpy (mqttSUB, "cmnd/");
  strcat (mqttSUB, espName);
  strcat (mqttSUB, "/ESP");

  strcpy (mqttESP, "stat/");
  strcat (mqttESP, espName);
  strcat (mqttESP, "/ESP");

  strcpy (mqttTEMP, "stat/");
  strcat (mqttTEMP, espName);
  strcat (mqttTEMP, "/TEMP");

  strcpy (mqttLWT, "tele/");
  strcat (mqttLWT, espName);
  strcat (mqttLWT, "/LWT");

  strcpy (mqttSTA, "tele/");
  strcat (mqttSTA, espName);
  strcat (mqttSTA, "/STATE");
}

String ipToString(IPAddress ip){
  String s="";
  for (int i=0; i<4; i++)
    s += i  ? "." + String(ip[i]) : String(ip[i]);
  return s;
}

String getMacAddress() {
  byte mac[6];
  WiFi.macAddress(mac);
  String cMac = "";
  for (int i = 0; i < 6; ++i) {
    cMac += String(mac[i],HEX);
    if(i<5)
    cMac += "-";
  }
  cMac.toUpperCase();
  return cMac;
}

void reconectez() {
  while (String(mqtt_user)==""){
    #if DEBUG
    Serial.println("Invalid user!");
    #endif
    delay(99999999);
  }
  
  // ma conectez la mqtt server
  while (!client.connected()) {
    client.setServer(mqttServer, mqttPort);
    #if DEBUG
    Serial.print("AtloopTempting MQTT connection...");
    #endif
    // Incerc sa ma reconectez cu LWT din 5 in 5 secunde
    if (client.connect(espName, mqtt_user, mqttPassword, mqttLWT, 1, 1, "Offline")) {
      #if DEBUG
      Serial.println("connected");
      #endif
      client.publish(mqttLWT,"Online",TRUE);
      // trimit informatii utile cand ma conectez
        String esp_info = "{\"ESPMac\":\"";
        esp_info += getMacAddress();
        esp_info += "\",\"IPAddress\":\"";
        esp_info += ipToString(WiFi.localIP());    
        esp_info += "\"}";       
        String netinfo = "{\"Module\":\"";
        netinfo += String (model);
        netinfo += "\",\"Version\":\"";
        netinfo += String (ver);
        netinfo += "\"}";            
        
        client.publish(mqttESP, netinfo.c_str(),TRUE);
        #if DEBUG
        Serial.println(netinfo);
        #endif
        client.publish(mqttESP, esp_info.c_str(),TRUE);
        #if DEBUG
        Serial.println(esp_info);
        #endif
        client.publish(mqttESP, "{\"LoopInterval\":\"15 minute\"}",TRUE); // trimit intervalul default
        client.subscribe(mqttSUB);
    } else {
      #if DEBUG
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 60 seconds");
      #endif
      // Wait 60 seconds before retrying
      delay(60000);
    }
  }
}

void setup()
{
  #if DEBUG
  Serial.begin(115200);
  #endif

  // Mount the filesystem
  bool result = SPIFFS.begin();
  #if DEBUG
  //Serial.println("SPIFFS opened: " + result);
  #endif
  
  readConfigFile(); //citesc user si devid din memorie
  generate_vars(); //genereaza topicurile de mqtt in baza mqtt_user si mqtt_devid
  
  // ma conectez la AP via wifi
   WiFiManager wifi;
   wifi.setConfigPortalTimeout(120); // a timeout so the ESP doesn't hang waiting to be configured, for instance after a power failure
   wifi.setTimeout(180); // sta AP 3 minute apoi se reseteaza din nou
   if (!wifi.autoConnect("ClickHome")) {
     #if DEBUG
     Serial.println("timeout - going to sleep");
     #endif
  }
  delay(200);

  reconectez();
  client.setCallback(getMessage); //setez functia care parseaza mesajele venite prin mqtt

  sensors.begin();
  update_state(); //facem update la mqtt cu Uptime
}

void update_state(){ //facem update la mqtt cu Uptime
    String json = "{\"Uptime\":";
    json += (int)millis()/3600000; //exprimat in ore
    json += "}";
    client.publish(mqttSTA, json.c_str(),FALSE);
}

void getMessage(char* topic, byte* payload, unsigned int length) {
  float t = 0;
  mqttMessage="";
  #if DEBUG
  Serial.print("Message arrived in topic: ");
  Serial.println(topic);
  Serial.print("Message:");
  #endif
  for (int i = 0; i < length; i++) {
    mqttMessage += (char)payload[i];
  }
  #if DEBUG
  Serial.println(mqttMessage);
  #endif
 
  // daca a primit sendTemp trimite temperatura 
  if (mqttMessage == "temp")
  {
    #if DEBUG
    Serial.println("Trimit temperatura");
    #endif
    sensors.setResolution(12);
    sensors.requestTemperatures(); // Send the command to get Temperatures
    t = sensors.getTempCByIndex(0);
      String json = "{\"Temp\":";
      json += String (t);
      json += "}";
      client.publish(mqttTEMP, json.c_str(),TRUE);
      #if DEBUG
      Serial.println(json);
      #endif
  }  
// reset la ESP
  if (mqttMessage == "reset")
  {
      String lastwords="Am fost resetat ...";
      client.publish(mqttESP, lastwords.c_str(), TRUE);
      delay (3000);
      ESP.reset();
      delay (5000);
  }
// procedura de software update via WEB
   if (mqttMessage == "update")
   {
        String msg="Software update: ";
        t_httpUpdate_return ret; 
        //ESPhttpUpdate.rebootOnUpdate(false);
        ret = ESPhttpUpdate.update("http://update.clickhome.ro/senzor/dallas/arduino.bin");  
        //ret = ESPhttpUpdate.update("update.clickhome.ro", 80, "/senzor/dallas/arduino.bin");
        switch(ret) {
           case HTTP_UPDATE_FAILED:
               msg.concat(" eroare:");
               msg.concat(ESPhttpUpdate.getLastError());
               msg.concat(" motiv:");
               msg.concat(ESPhttpUpdate.getLastErrorString().c_str());
               break;
           case HTTP_UPDATE_NO_UPDATES:
               msg.concat(" no update.");
               break;
           case HTTP_UPDATE_OK:
               msg.concat(" success.");
               break;
        }
        #if DEBUG
        Serial.println(msg);
        #endif
   }

  // daca a primit valoarea in minute seteaza loopTimer si-l trimite in DB
  
   if (mqttMessage == "debug")
   {
        loopTimer=30000; // setez sa trimita valori la 30 de secunde ca sa fac debug
        client.publish(mqttESP, "{\"LoopInterval\":\"30 secunde\"}",TRUE);   
   }
   if (mqttMessage == "10")
   {
        loopTimer=600000; // setez sa trimita valori la 10 minute   
        client.publish(mqttESP, "{\"LoopInterval\":\"10 minute\"}",TRUE);
   }
   if (mqttMessage == "15")
   {
        loopTimer=900000; // setez sa trimita valori la 15 minute
        client.publish(mqttESP, "{\"LoopInterval\":\"15 minute\"}",TRUE);   
   }
   if (mqttMessage == "30")
   {
        loopTimer=1800000; // setez sa trimita valori la 30 de minute
        client.publish(mqttESP, "{\"LoopInterval\":\"30 de minute\"}",TRUE);   
   }   
   if (mqttMessage == "60")
   {
        loopTimer=3600000; // setez sa trimita valori la o ora
        client.publish(mqttESP, "{\"LoopInterval\":\"o ora\"}",TRUE);   
   }
   if (mqttMessage == "stop")
   {
        loopTimer=3600000000; // setez sa nu trimita valori
        client.publish(mqttESP, "{\"LoopInterval\":\"oprit\"}",TRUE);
   }  
}

bool readConfigFile() {
  // this opens the config file in read-mode
  File f = SPIFFS.open("/config.json", "r");
  
  if (!f) {
    #if DEBUG
    Serial.println("Configuration file not found");
    #endif
    return false;
  } else {
    // we could open the file
    size_t size = f.size();
    // Allocate a buffer to store contents of the file.
    std::unique_ptr<char[]> buf(new char[size]);

    // Read and store file contents in buf
    f.readBytes(buf.get(), size);
    // Closing file
    f.close();
    // Using dynamic JSON buffer which is not the recommended memory model, but anyway
    // See https://github.com/bblanchon/ArduinoJson/wiki/Memory%20model
    DynamicJsonBuffer jsonBuffer;
    // Parse JSON string
    JsonObject& json = jsonBuffer.parseObject(buf.get());
    // Test if parsing succeeds.
    if (!json.success()) {
      #if DEBUG
      Serial.println("JSON parseObject() failed");
      #endif
      return false;
    }
    #if DEBUG
    json.printTo(Serial);
    #endif
    strcpy(mqtt_user, json["mqtt_user"]);
    strcpy(mqtt_devid, json["mqtt_devid"]);
  }
  return true;
}


void loop()
{
  if (!client.connected()) {
    reconectez();
  }
  client.loop();
  //facem update la $interval_update cu uptime
  if (millis() - t_update > interval_update){
    update_state();
    t_update=millis();
  }
  //end update

  if (millis() - lastMsg > loopTimer) {
    lastMsg = millis();
    sensors.setResolution(12);
    sensors.requestTemperatures(); // Send the command to get loopTemperatures
    loopTemp = sensors.getTempCByIndex(0);
    #if DEBUG
    Serial.println(loopTemp);
    #endif
    if((loopTemp > -20) && (loopTemp <60)){
     String val = "{\"Temp\":";
      val += String (loopTemp);
      val += "}";
      client.publish(mqttESP, val.c_str(),TRUE);
    }
  }
}

