#!/usr/bin/perl
# parser pentru mesajele MQTT
# Version: 1.0.0 
use strict;
use warnings;
use JSON qw( decode_json );
use DBI;
use Proc::Daemon;

# partea de daemon
###################################
Proc::Daemon::Init;
my $continue = 1;
$SIG{TERM} = sub { $continue = 0 };
###################################

# citesc fisierul de config
my $config = '/etc/mqttparser.conf';
open my $CFG, $config or die "Could not open my $config: my $!";

my $db;
my $dbuser;
my $dbpass;
my $dbhost;
my $mqttuser;
my $mqttpass;
my $row=1;
while( my $line = <$CFG>){
  my @credentials = split /=/, $line;
  if ($row==1) {$db = $credentials[1]; chomp($db);}
  if ($row==2) {$dbuser = $credentials[1]; chomp($dbuser);}
  if ($row==3) {$dbpass = $credentials[1]; chomp($dbpass);}
  if ($row==4) {$dbhost = $credentials[1]; chomp($dbhost);}
  if ($row==5) {$mqttuser = $credentials[1]; chomp($mqttuser);}
  if ($row==6) {$mqttpass = $credentials[1]; chomp($mqttpass);}
  $row++;
}
close $CFG;

# scriu pid-ul
open PID, ">>/var/run/mqttparser.pid" or die "Couldn't open file: $!";
print PID "$$\n";
close PID;

my $dbh = DBI->connect("DBI:mysql:$db:$dbhost", $dbuser, $dbpass);
open(my $SUB, "/usr/bin/mosquitto_sub -u $mqttuser -P $mqttpass -v -t \"stat/rqx958t-1459/#\" |");
while (my $mqttMessage = <$SUB> ) {
    # spargem mqttMessage in doua, dupa primul spatiu si obtinem topicul si json-ul:
    (my $topic, my $json) = split /\ /, $mqttMessage, 2;
    my $decoded = decode_json($json);
    my $query = "insert into mqttparser values (?, ?, ?)";
    my $sqlQuery  = $dbh->prepare($query) or die "Can't prepare $query: $dbh->errstr\n";
    $sqlQuery->execute('0', $decoded->{'Temp'}, '2');
    $sqlQuery->finish();
}
$dbh->disconnect;

# partea de daemon
###################################
while ($continue) {
}
###################################
