#include <ESP8266WiFi.h>
#include <PubSubClient.h>
#include <WiFiManager.h>        //https://github.com/tzapu/WiFiManager
#include <WiFiClient.h> 
#include <OneWire.h>
#include <DallasTemperature.h>

// Modifica cu datele tale
const char* mqttUser = "rqx958t";
const char* mqttPassword = "8219CHrqx958t";
const char* mqttSUB = "cmnd/rqx958t-1460/ESP";
const char* mqttESP = "stat/rqx958t-1460/ESP";
const char* mqttTEMP = "stat/rqx958t-1460/TEMP";
const char* mqttLWT = "tele/rqx958t-1460/LWT";
const char* espName ="rqx958t-1460";

//#######################################################################
// NU EDITA MAI JOS
//#######################################################################
const String model = "NodeMCU Dallas";
const String ver = "v1.0.5";
const char* mqttServer = "mqtt.clickhome.ro";
const int mqttPort = 1883;
long loopTimer = 900000; // miliseconds - by default trimite la 15 minute
long lastMsg = 0;
float loopTemp = 0;
int inPin = 5;
String mqttMessage;

// senzor de temperatura DALLAS
#define ONE_WIRE_BUS D4  // pinul de date (la mine am pus senzor pe D4)
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

//*********************************************************************

WiFiClient espClient;
PubSubClient client(espClient);


String ipToString(IPAddress ip){
  String s="";
  for (int i=0; i<4; i++)
    s += i  ? "." + String(ip[i]) : String(ip[i]);
  return s;
}

String getMacAddress() {
  byte mac[6];
  WiFi.macAddress(mac);
  String cMac = "";
  for (int i = 0; i < 6; ++i) {
    cMac += String(mac[i],HEX);
    if(i<5)
    cMac += "-";
  }
  cMac.toUpperCase();
  return cMac;
}

void reconnect() {
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("AtloopTempting MQTT connection...");
    // Incerc sa ma reconectez cu LWT din 5 in 5 secunde
    if (client.connect(espName, mqttUser, mqttPassword, mqttLWT, 1, 1, "Offline")) {
      Serial.println("connected");
      client.publish(mqttLWT,"Online",TRUE);
      // trimit informatii utile cand ma conectez
        String esp_info = "{\"ESPMac\":\"";
        esp_info += getMacAddress();
        esp_info += "\", \"IPAddress\":\"";
        esp_info += ipToString(WiFi.localIP());    
        esp_info += "\"}";       
        String netinfo = "{\"Module\":\"";
        netinfo += String (model);
        netinfo += "\", \"Version\":\"";
        netinfo += String (ver);
        netinfo += "\"}";            
        
        client.publish(mqttESP, netinfo.c_str(),TRUE);
        Serial.println(netinfo);
        client.publish(mqttESP, esp_info.c_str(),TRUE);
        Serial.println(esp_info);
        client.publish(mqttESP, "15 minute",TRUE); // trimit intervalul default
        client.subscribe(mqttSUB);
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 60 seconds");
      // Wait 5 seconds before retrying
      delay(60000);
    }
  }
}
 
void setup()
{
  Serial.begin(115200);

  // ma conectez la AP via wifi
   WiFiManager wifi;
   wifi.setTimeout(180); // sta AP 3 minute apoi se reseteaza din nou
   if (!wifi.autoConnect("ClickHome")) {
     Serial.println("timeout - going to sleep");
  }
  delay(200);
 
  // ma conectez la mqtt server
  client.setServer(mqttServer, mqttPort);
    while (!client.connected()) {
    Serial.println("Connecting to MQTT...");
    // fac connect cu LWT
    if (client.connect(espName, mqttUser, mqttPassword, mqttLWT, 1, 1, "Offline")) {
      // trimit starea Online pe topic LWT cand ma conectez
      client.publish(mqttLWT,"Online",TRUE);
      // trimit informatii utile cand ma conectez
        String esp_info = "{\"ESPMac\":\"";
        esp_info += getMacAddress();
        esp_info += "\", \"IPAddress\":\"";
        esp_info += ipToString(WiFi.localIP());    
        esp_info += "\"}";       
        String netinfo = "{\"Module\":\"";
        netinfo += String (model);
        netinfo += "\", \"Version\":\"";
        netinfo += String (ver);
        netinfo += "\"}";        
        client.publish(mqttESP, netinfo.c_str(),TRUE);
        Serial.println(netinfo);
        client.publish(mqttESP, esp_info.c_str(),TRUE);
        Serial.println(esp_info);
        client.publish(mqttESP, "{\"LoopInterval\":\"15 minute\"}",TRUE);   
        Serial.println("connected");
        client.subscribe(mqttSUB);
      } 
      else {
        Serial.print("failed with state ");
        Serial.print(client.state());
        delay(2000);
    }
  }
  // astept mesajul de la serverul MQTT
  client.setCallback(getMessage);
  pinMode(inPin, INPUT);
  sensors.begin();
}

void getMessage(char* topic, byte* payload, unsigned int length) {
  float t = 0;
  mqttMessage="";
  Serial.print("Message arrived in topic: ");
  Serial.println(topic);
  Serial.print("Message:");
  for (int i = 0; i < length; i++) {
    mqttMessage += (char)payload[i];
  }
  Serial.println(mqttMessage);
 
  // daca a primit sendTemp trimite temperatura 
  if (mqttMessage == "temp")
  {
    Serial.println("Trimit temperatura");
    sensors.setResolution(12);
    sensors.requestTemperatures(); // Send the command to get Temperatures
    t = sensors.getTempCByIndex(0);
      String json = "{\"Temp\":";
      json += String (t);
      json += "}";
      client.publish(mqttTEMP, json.c_str(),TRUE);
      Serial.println(json);
  }  

  // daca a primit valoarea in minute seteaza loopTimer si-l trimite in DB
  
   if (mqttMessage == "debug")
   {
        loopTimer=30000; // setez sa trimita valori la 30 de secunde ca sa fac debug
        client.publish(mqttESP, "{\"LoopInterval\":\"30 secunde\"}",TRUE);   
   }
   if (mqttMessage == "10")
   {
        loopTimer=600000; // setez sa trimita valori la 10 minute   
        client.publish(mqttESP, "{\"LoopInterval\":\"10 minute\"}",TRUE);
   }
   if (mqttMessage == "15")
   {
        loopTimer=900000; // setez sa trimita valori la 15 minute
        client.publish(mqttESP, "{\"LoopInterval\":\"15 minute\"}",TRUE);   
   }
   if (mqttMessage == "30")
   {
        loopTimer=1800000; // setez sa trimita valori la 30 de minute
        client.publish(mqttESP, "{\"LoopInterval\":\"30 de minute\"}",TRUE);   
   }   
   if (mqttMessage == "60")
   {
        loopTimer=3600000; // setez sa trimita valori la o ora
        client.publish(mqttESP, "{\"LoopInterval\":\"o ora\"}",TRUE);   
   }
   if (mqttMessage == "stop")
   {
        loopTimer=3600000000; // setez sa nu trimita valori
        client.publish(mqttESP, "{\"LoopInterval\":\"oprit\"}",TRUE);
   }  
}

void loop()
{
  if (!client.connected()) {
    reconnect();
  }
  client.loop();
  long now = millis();
  if (now - lastMsg > loopTimer) {
    lastMsg = now;
    sensors.setResolution(12);
    sensors.requestTemperatures(); // Send the command to get loopTemperatures
    loopTemp = sensors.getTempCByIndex(0);
    Serial.println(loopTemp);
    if((loopTemp > -20) && (loopTemp <60))
      {
     String val = "{\"Temp\":";
      val += String (loopTemp);
      val += "}";
      client.publish(mqttESP, val.c_str(),TRUE);
      }
  }
}
